//
//  MCClientEndpoint.h
//  MCNetComm
//
//  Created by Brent Gulanowski on 21/05/09.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import "MCFileTransferEndpoint.h"


/*
 
 MCClientEndpoint is an abstract class suitable for extending with the client side of your protocol. It incorporates the concept of a server ready state,
 and a queue of outgoing messages. The queue can be filled in advance; messages on the queue will be sent in order as the server sends ready messages.
 
 The client endpoint will optionally inform the delegate before and after each messages is actually sent. This will save subclasses or delegates having
 to sprinkle logic for tracking client state all over the place, or at least reduce it.
 
 Most subclasses can then concentrate on simply writing send methods, which will insert outgoing methods into the queue, and handlers, which should
 unpack incoming messages and then forward relevant payload data to the delegate for real processing.
 
 This class makes a good companion to the MCSimpleServerEndpoint class.
 
 */


@interface MCClientEndpoint : MCFileTransferEndpoint {

	id delegate; // weak
	NSMutableArray *outgoingCommands;

	BOOL opening;
	NSArray *hostAddressesToTry;
	unsigned short hostPortToTry;
	int currentHostAddressToTry;
	
	BOOL useSSL;
	BOOL didStop;
	
	NSString * responseAddress;
	NSUInteger responsePort;
}

@property(retain) NSString * responseAddress;
@property(readwrite) NSUInteger responsePort;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

- (BOOL)useSSL;
- (void)setUseSSL:(BOOL)flag;

- (NSString *)hostAddress;
- (unsigned short)hostPort;

- (id)initWithHostAddresses:(NSArray *)hostAddresses port:(unsigned short)hostPort;
- (id)initWithHostAddress:(NSString *)hostAddress port:(unsigned short)hostPort;

- (void)appendCommandMessage:(NSDictionary *)message;
- (void)appendCommand:(NSString *)command; // puts it in a mesage dictionary for you
- (BOOL)popCommandMessage; // returns YES if there was a message to send, NO if not



@end


@interface MCClientEndpoint (MCClientEndpointSubclass)

- (BOOL)readyToSend;

@end


@interface NSObject (MCClientEndpointDelegate)

- (BOOL)clientEndpoint:(MCClientEndpoint *)endpoint willSendMessage:(NSDictionary **)message;
- (BOOL)clientEndpoint:(MCClientEndpoint *)endpoint didSendMessage:(NSDictionary *)message;

- (void)clientEndpointCouldNotConnect:(MCClientEndpoint *)endpoint;
- (void)clientEndpointDidConnect:(MCClientEndpoint *)endpoint;
- (void)clientEndpointLostConnection:(MCClientEndpoint *)endpoint;

@end


